package gov.va.med.mhv.common.data.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.FacilityPreferenceDTO;
import gov.va.med.mhv.common.data.model.FacilityPreference;
import gov.va.med.mhv.common.data.model.Patient;

@Component
public class FacilityPreferenceConverter {

	@Autowired
	private FacilityConverter facilityConverter;
	
	@Autowired
	PatientConverter patientConverter;
	
	public FacilityPreferenceDTO convertDomainObject(FacilityPreference facilityPreference) {
		FacilityPreferenceDTO facilityPreferenceDto = new FacilityPreferenceDTO();
		facilityPreferenceDto.setId(facilityPreference.getId());
		facilityPreferenceDto.setFacilityId(facilityPreference.getFacilityId());
		facilityPreferenceDto.setFacility(facilityConverter.convertDomainFacility(facilityPreference.getFacility()));
		facilityPreferenceDto.setPatient(patientConverter.convertDomainPatient(facilityPreference.getPatient()));
		facilityPreferenceDto.setPatientId(facilityPreference.getPatientId());
		facilityPreferenceDto.setCreatedDate(facilityPreference.getCreatedDate());
		facilityPreferenceDto.setModifiedDate(facilityPreference.getModifiedDate());
		
		return facilityPreferenceDto;
		
	}
	
	public FacilityPreference convertDTOObject(FacilityPreferenceDTO facilityPreferenceDto, Patient patient) {
		
		FacilityPreference facilityPreference = new FacilityPreference();
		facilityPreference.setId(facilityPreferenceDto.getId());
		facilityPreference.setFacilityId(facilityPreferenceDto.getFacilityId());
		facilityPreference.setFacility(facilityConverter.coonvertDTOFacility((facilityPreferenceDto.getFacility())));
		facilityPreference.setPatient(patient);
		facilityPreference.setPatientId(facilityPreferenceDto.getPatientId());
		facilityPreference.setCreatedDate(facilityPreferenceDto.getCreatedDate());
		facilityPreference.setModifiedDate(facilityPreferenceDto.getModifiedDate());
		
		return facilityPreference;
	}
}
